USE $(DATA_BASE_NAME);
GO

/****** Object:  StoredProcedure [dm].[CalcHomelessRegistryReviewTime]    Script Date: 5/16/2016 12:57:46 PM ******/
DROP PROCEDURE [dm].[CalcHomelessRegistryReviewTime]
GO

/****** Object:  StoredProcedure [dm].[CalcHomelessRegistryReviewTime]    Script Date: 5/16/2016 12:57:46 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO








CREATE procedure [dm].[CalcHomelessRegistryReviewTime]
as
with init as (select e.requestId RequestID, Row_Number() over (partition by e.requestId, e.reviewId order by e.CreatedOn asc) RID, 
'Homeless Registry' as RevType, e.createdOn SD,null EndDate,0 RevCount,0 isApproved,0 isDenied,null as CurrentStatus, e.reviewId  
from Hib.Event e
    left join dm.ReviewAggregate ra on e.requestId = ra.requestID and ra.reviewId = e.reviewId and ReviewType = 'Homeless Registry'
where 
    e.Name = 'Request Sent for Homeless Registry Review'
    and (ra.RequestID is null or (ra.reviewId != e.reviewid ) ) )

Insert into dm.ReviewAggregate(requestID,ReviewType,StartDate,EndDate,RevisionCount,isApproved,isdenied,CurrentStatus,reviewId)
select RequestID, RevType,SD,EndDate,RevCount,isApproved,isdenied,CurrentStatus, reviewId  from INIT
where RID = 1

;with base as (select Row_Number() over (partition by requestID, reviewid order by createdOn) RID, ev.*
from hib.[Event] ev inner join hib.[eventgroup] eg on ev.id = eg.eventid
where (ev.name like '%Homeless Registry%' or (ev.eventtypeid = 13 and eg.groupid = 16 ) )
and EventTypeID != 4)

, base2 as (select c1.RequestID, c1.reviewid, Case when c1.Name = 'Request Sent for Homeless Registry Review' then 'Reviewer'
                    when c1.Name = 'Change Requested by Homeless Registry' then 'Requestor'                 
                    when c1.Name = 'Homeless Registry Review Approval' then 'N/A'
                    when c1.Name = 'Homeless Registry Review Denied' then 'N/A'
                    when c1.Name like '%Withdrawn%' then 'N/A' end as Actor
                    , dbo.udf_GetCalendarDays(c1.CreatedOn, Coalesce(c2.CreatedOn,getdate())) as CalDayCount
                    , dbo.udf_GetBusinessDays(c1.CreatedOn, Coalesce(c2.CreatedOn,getdate())) as BusDayCount
from Base c1 
    left join Base c2 on c1.RequestID = c2.RequestID and c1.reviewId = C2.reviewId and c1.RID = c2.RID -1)
--Update table 

, base3 as (select requestID, reviewId
                            , max(Case when Actor = 'Requestor' then BusDayCount end) ReqBusDays
                            , Max(Case when Actor = 'Reviewer'  then BusDayCount end) RevBusDays
                            , max(Case when Actor = 'Requestor' then CalDayCount end) ReqCalDays
                            , Max(Case when Actor = 'Reviewer'  then CalDayCount end) RevCalDays
from base2 b
where actor != 'N/A'
group by requestID, reviewId)



Update agg
    set agg.TotalReviewerBusinessDays = coalesce(b.RevBusDays,0)
    , agg.TotalRequestorBusinessDays = coalesce(b.ReqBusDays,0)
    , agg.TotalReviewerCalendarDays = coalesce(b.RevCalDays,0)
    , agg.TotalRequestorCalendarDays = coalesce(b.ReqCalDays,0)
from base3 b
    inner join dm.ReviewAggregate agg on b.requestID = agg.RequestID and b.reviewid = agg.reviewId and reviewType = 'Homeless Registry'


/*Update Approved/Denied.Withdrawn recs*/
Update  ra
    set ra.isApproved = Case when e.Name = 'Homeless Registry Review Approval' then 1 else 0 end
        ,ra.isDenied =  Case when e.Name = 'Homeless Registry Review Denied' then 1 else 0 end
        ,ra.EndDate = e.CreatedOn
        ,ra.CurrentStatus = Case when e.Name = 'Homeless Registry Review Approval' then 'Approved' 
                                 when e.Name = 'Homeless Registry Review Denied' then 'Denied' end
from dm.ReviewAggregate ra
    inner join hib.[Event] e on ra.RequestID = e.RequestID and ra.reviewId = e.reviewId
where ra.ReviewType = 'Homeless Registry'
and e.Name in ('Homeless Registry Review Approval','Homeless Registry Review Denied')
    
Update  ra
    set ra.isApproved = 0
        ,ra.isDenied =  0
        ,ra.TotalReviewerBusinessDays = 0
        ,ra.TotalRequestorBusinessDays = 0
        ,ra.TotalReviewerCalendarDays = 0
        ,ra.TotalRequestorCalendarDays = 0
        ,ra.EndDate = e.CreatedOn
        ,ra.CurrentStatus = 'Withdrawn' 
  from dm.ReviewAggregate ra
    inner join hib.[Event] e on ra.RequestID = e.RequestID and ra.reviewId = e.reviewId
where ra.ReviewType = 'Homeless Registry'
and e.Name like '%Withdrawn%'
    
;with mxEvent as (select e.RequestID, e.reviewid, max(createdOn) createdOn
from dm.ReviewAggregate ra
    inner join hib.[Event] e on ra.requestID = e.RequestID and ra.reviewId = e.reviewid
where ra.ReviewType = 'Homeless Registry'
and e.Name like '%Homeless Registry%'
and ra.EndDate is null
and e.EventTypeID != 4
group by e.RequestID, e.reviewId)


Update  ra
    set ra.isApproved = 0
        ,ra.isDenied =  0
        ,ra.EndDate = null
        ,ra.CurrentStatus = Case when Name = 'Change Requested By Homeless Registry' then 'Waiting for Requestor' 
                                                when Name = 'Request Sent for Homeless Registry Review' then 'Waiting for Reviewer' end 
from dm.ReviewAggregate ra
inner join mxEvent b on ra.RequestID = b.RequestID and ra.reviewId = b.reviewid 
    inner join hib.[event] e on b.requestID = e.RequestID and b.reviewid = e.reviewid and b.CreatedOn = e.CreatedON and e.Name like '%Homeless Registry%' and e.EventTypeID != 4
where ra.reviewType = 'Homeless Registry';



GO


